/*
Todo:
- fallback html file
- check selects inside expanders
- alpha transparent background?
- display: none on content (because content blocks links)
- expand on mouse over and restore on mouse out for popup menus?
*/
hs.overrides.push('htmlAllowWidthReduction');
hs.overrides.push('htmlAllowHeightReduction');
hs.htmlAllowWidthReduction = false;
hs.htmlAllowHeightReduction = true;

// These properties can be overridden in the function call for each expander:
hs.htmlExpand = function(a, divId, params) {
	if (!hs.$(divId)) return true;
	hs.isBusy = true;
	if (1==1) {
    	var exp = new HsExpander(a, params, 'html');
		//var key = hs.expandedImagesCounter - 1;
		//var exp = hs.expanders[key];
		if (exp.a != a) return false;
		
		exp.origContent = hs.$(divId);
		exp.origContent.style.position = 'relative';
    	
    	var div = hs.createElement('div', null,
			{
				padding: '0 '+ hs.marginRight +'px 0 '+ hs.marginLeft +'px',
				position: 'absolute',
				left: 0,
				top: 0
			},
			document.body
		);
		div.appendChild(exp.origContent); // to get full width
		exp.origContent.style.visibility = 'hidden';
		exp.origContent.style.display = 'block';
		
    	//hs.getCssSize(key, divId);
    	exp.htmlCreate(divId);
		exp.onLoad();
		return false;
	} else /* catch */ {
		return true; // script failed: try firing default href
	}
	
}
HsExpander.prototype.htmlCreate = function (divId) {
	this.innerContentId = divId;
	this.innerContent = this.origContent.cloneNode(true);
    //this.innerContent.style.visibility = 'visible';
    this.innerContent.style.border = 'none';
    this.innerContent.style.width = 'auto';
    this.innerContent.style.height = 'auto';
    //this.innerContent.style.overflow = 'hidden';
    var content = document.createElement('div'); // to achieve borders
    content.className = 'highslide-html';
    content.style.position = 'relative';
	content.style.zIndex = 3;
    content.style.overflow = 'hidden';	
	content.style.width = this.thumbWidth +'px';
	content.style.height = this.thumbHeight +'px';
	//content.setAttribute('key', key); // used on drag
    content.appendChild(this.innerContent);
    this.content = content;
    
    this.newWidth = this.origContent.offsetWidth;
    this.newHeight = this.origContent.offsetHeight;
    if (hs.ie && this.newHeight > parseInt(this.origContent.currentStyle.height)) { // ie css bug
		this.newHeight = parseInt(this.origContent.currentStyle.height);
	}
	
	// hide origContent
	this.origContent.style.display = 'none';
    
    /*
    if (hs.getStyle(this.origContent, 'width') == 'auto') { // reflow to get offsetHeight
    	this.origContent.style.width = this.htmlSize.width +'px';
	}
	
	this.newWidth = this.htmlSize.width > 0 ? this.htmlSize.width : this.origContent.offsetWidth;
	this.newHeight = this.htmlSize.height > 0 ? this.htmlSize.height : this.origContent.offsetHeight;
	*/
}
HsExpander.prototype.htmlSizeOperations = function () {
	// store for resize
    this.finalLeft = this.x.min;
    this.finalTop = this.y.min;
    
    
    
    // handle minimum size   
    if (this.x.span < this.newWidth) {
    	if (!this.htmlAllowWidthReduction) {
    		this.x.span = this.newWidth;
    		setTimeout(
    			"if (hs.expanders["+ this.key +"])"
    			+ "hs.expanders["+ this.key +"].innerContent.style.width = 'auto'", 
    			hs.expandDuration
    		);
    		
		} 
		
		
		/*else { if (this.x.span < this.htmlSize.minWidth) {
			this.x.span = this.htmlSize.minWidth;
		}*/
	}
	//this.innerContent.style.width = this.x.span +'px';
	//this.y.span = this.htmlSize.height > 0 ? this.htmlSize.height : this.innerContent.offsetHeight;
	
	
    if (this.y.span < this.newHeight) {
    	if (!this.htmlAllowHeightReduction) {
    		this.y.span = this.newHeight;  
    		setTimeout(
    			"if (hs.expanders["+ this.key +"]) "
    			+ "hs.expanders["+ this.key +"].innerContent.style.height = 'auto'", 
    			hs.expandDuration
    		);
		} 
		/*else if (this.y.span < this.htmlSize.minHeight) {
			this.y.span = this.htmlSize.minHeight;
		}*/
	}
	
    // correct scrollbars
    this.scrollerDiv = 'innerContent';
    
    // scrolling-content
    //if (this.x.span < this.newWidth || this.y.span < this.newHeight) {
    	//var icHeight = this.innerContent.style.height;
    	//this.innerContent.style.width = this.x.span +'px'; // to correct offsetHeight (displaces padding)
    	// to get correct offsetHeight:
    	this.mediumContent = hs.createElement('div', null, { width: this.x.span +'px'}, this.content);
    	this.mediumContent.appendChild(this.innerContent);
    	
    	for (i = 0; i < this.innerContent.childNodes.length; i++) {
    		var node = this.innerContent.childNodes[i];
    		if (node.className == 'highslide-scrolling-content') {
    			var cNode = node.cloneNode(true); // to get true width
    			
    			node.innerHTML = '';
    			hs.setStyles ( node, 
    				{
    					margin: 0,
    					border: 'none',
    					padding: 0
					}
    			);
    			node.appendChild(cNode);
    		
    			var wDiff = this.innerContent.offsetWidth - node.offsetWidth;
    			var hDiff = this.innerContent.offsetHeight - node.offsetHeight;
    			
    			node.style.width = (this.x.span - wDiff) +'px';
    			node.style.height = (this.y.span - hDiff + 1) +'px';
    			node.style.overflow = 'auto';
    			
    			this.scrollingContent = node;
    			this.scrollerDiv = 'scrollingContent';
    			
    			break;
			}
		}
		if (!this.scrollingContent) this.scrollerDiv = 'content'; // because innerContent size set to auto
	//}
	if (this.scrollerDiv == 'content' && !this.htmlAllowWidthReduction) {
		this.x.span += 25; // room for scrollbars to prevent text from repositioning
	}
	setTimeout("hs.expanders["+ this.key +"]."+ this.scrollerDiv +".style.overflow = 'auto'", hs.expandDuration);
    
}
HsExpander.prototype.htmlSetSize = function (width, height, left, top, isFinal) {
	if (1==1) {
		this.content.style.width = width +'px';
        this.content.style.height = height +'px';
		this.wrapper.style.visibility = 'visible';
		this.wrapper.style.left = left +'px';
		this.wrapper.style.top = top +'px';
		
		this.mediumContent.style.marginLeft = (this.finalLeft - left) +'px';
		this.mediumContent.style.marginTop = (this.finalTop - top) +'px';
		this.innerContent.style.visibility = 'visible';
		this.thumb.style.visibility = 'hidden';
		
	} else /* catch */ {
		window.location.href = hs.expanders[key].a.href;
	}
}
/*
hs.getCssSize = function (key, divId) {
	var exp = hs.expanders[key];
	var el = exp.origContent;
	exp.htmlSize = { 
		'width': 0, 
		'height': 0, 
		'minWidth': 0, 
		'minHeight': 0, 
		'maxWidth': 0, 
		'maxHeight': 0 
	};
	if (hs.ie && hs.ieVersion() < 7) {
		// look in stylesheets
		for(i = 0; i < document.styleSheets.length; i++) {
			var ss = document.styleSheets[i];
			for (j = 0; j < ss.rules.length; j++) {
				var rule = ss.rules[j];
				if (rule.selectorText.match('.highslide-html-content')
						|| (exp.innerContentId && rule.selectorText.match('#'+ exp.innerContentId))) 
				{
					hs.parseCssText(key, rule.style.cssText);
					
					//print_r(exp.htmlSize);return;
				}
			}
		}
		
		// look in document's style tags
		var tags = document.getElementsByTagName('style');
		for (i = 0; i < tags.length; i++) {
			var ss = tags[i].styleSheet;
			for (j = 0; j < ss.rules.length; j++) {
				var rule = ss.rules[j];
				if (rule.selectorText.match('.highslide-html-content')
						|| (exp.innerContentId && rule.selectorText.match('#'+ exp.innerContentId))) 
				{
					hs.parseCssText(key, rule.style.cssText);
				}
			}
		}
	
		// look in inline style
		hs.parseCssText(key, el.style.cssText);

		
	} else {
		for (var x in exp.htmlSize) {
			var re = /^([0-9]+)px$/;
			var val = hs.getStyle(el, hs.jsToCss(x));
			if (val.match(re)) {
				exp.htmlSize[x] = val.replace(re, '$1');
			} else {
				exp.htmlSize[x] = 0;
			}
		}	
	}
	if (!exp.htmlSize.width) {
		exp.htmlSize.width = exp.htmlSize.maxWidth;
	}
			
	print_r(exp.htmlSize);return;
}
hs.parseCssText = function(key, s) {
	if (s == "") return;
	var exp = hs.expanders[key];
	var propsArr = s.split(';');
	var props = Array();
	for (i = 0; i < propsArr.length; i++) {
		var assoc = propsArr[i].split(':');
		var trimKey = assoc[0].replace(/^\s*(\S+)\s*$/, '$1').toLowerCase();
		var trimValue = assoc[1].replace(/^\s*(\S+)\s*$/, '$1');
		props[hs.cssToJs(trimKey)] = trimValue;
	}
	for (var x in props) {
		var re = /^([0-9]+)px$/;
		if (exp.htmlSize[x] != null && props[x].match(re)) {
			var val = props[x].replace(re, "$1");
			var h = exp.htmlSize;
			switch (x) { // correct overrides according to FF
				case 'minWidth':
					if (h.maxWidth < val && h.maxWidth != 0) h.maxWidth = val;
					break;
				case 'maxWidth':
					if (h.minWidth > val) { // override
						h.maxWidth = h.minWidth;
					}
					break;
				case 'minHeight':					
					if (h.maxHeight < val && h.maxHeight != 0) h.maxHeight = val;
					break;
				case 'maxHeight':
					if (h.minHeight > val) { // override
						h.maxHeight = h.minHeight;
					}
					break;
			}
			h[x] = val;
			exp.htmlSize = h;
		}
	}
}
hs.jsToCss = function (s) {
	return s.replace(/([A-Z])/, function (strMatch, p1){
        return '-'+ p1.toLowerCase();
    });
}
hs.cssToJs = function (s) {
	return s.replace(/\-(\w)/g, function (strMatch, p1){
        return p1.toUpperCase();
    });
}
hs.getStyle = function (oElm, strCssRule){
    var strValue = "";
    if(document.defaultView && document.defaultView.getComputedStyle){
        strValue = document.defaultView.getComputedStyle(oElm, "").getPropertyValue(strCssRule);
    }
    
    else if(oElm.currentStyle){
        strCssRule = strCssRule.replace(/\-(\w)/g, function (strMatch, p1){
            return p1.toUpperCase();
        });
        strValue = oElm.currentStyle[strCssRule];
    }
    return strValue;
}
*/
